<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Contracts\View\View;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class UserController extends Controller
{
    public function index(): View
    {
        $user = User::where('id', '!=', 1)->get();
        $data = [
            'title' => 'Admin Ramizah Store | Data User',
            'page' => 'Data User',
            'menuOpen' => 'user',
            'menuActive' => 'user',
        ];
        return view('admin.user.user', compact('user', 'data'))->with('no', '1');
    }

    public function store(Request $request): RedirectResponse
    {
        $request->validate(
            [
                'nm_user'         => 'required',
                'username'   => 'required|unique:users,username',
                'password'         => 'required|min:6|confirmed',
                'password_confirmation'  => 'required',
                'level'         => 'required'
            ],
            [
                'required' => 'Form wajib diisi!',
                'unique' => 'Username sudah pernah diinputkan, silahkan input username lain!',
                'min' => 'Password minimal 6 digit!',
                'confirmed' => 'Konfirmasi password salah!',
            ]
        );

        User::create([
            'nm_user'         => $request->nm_user,
            'username'   => $request->username,
            'password'         => bcrypt($request->password),
            'level'         => $request->level
        ]);

        return redirect()->route('user.index')->with(['success' => 'Data Berhasil Disimpan!']);
    }


    public function update(Request $request): RedirectResponse
    {
        $username = $request->username;
        $usrlama = $request->usrlama;

        if ($username != $usrlama) {
            $rule = 'required|unique:users,username';
        } else {
            $rule = 'required';
        }

        $request->validate(
            [
                'nm_user'         => 'required',
                'username'   => $rule,
                'level'         => 'required'
            ],
            [
                'required' => 'Form wajib diisi!',
                'unique' => 'Username sudah pernah diinputkan, silahkan input username lain!',
            ]
        );

        $id = $request->id;

        $user = User::findOrFail($id);

        $user->update([
            'nm_user'         => $request->nm_user,
            'username'   => $request->username,
            'level'         => $request->level
        ]);

        return redirect()->route('user.index')->with(['success' => 'Data Berhasil Diubah!']);
    }

    public function destroy($id)
    {
        User::findOrFail($id)->delete();
        return redirect()->route('user.index')->with(['success' => 'Data Berhasil Dihapus!']);
    }

    public function password()
    {
        $data = [
            'title' => 'Panel Ramizah Store | Ubah Password',
            'page' => 'Ubah Password',
            'menuActive' => 'password',
            'menuOpen' => 'password',
        ];
        return view('admin.user.password', compact('data'));
    }

    public function ubahpassword(Request $request): RedirectResponse
    {
        $request->validate(
            [
                'pass_lama'  => 'required',
                'password'         => 'required|min:6|confirmed',
                'password_confirmation'  => 'required',
            ],
            [
                'required' => 'Form wajib diisi!',
                'min' => 'Password minimal 6 digit!',
                'confirmed' => 'Konfirmasi password salah!',
            ]
        );

        $user = Auth::user();
        if (!Hash::check($request->pass_lama, $user->password)) {
            return redirect()->back()->with('errpass', 'Password lama anda salah');
        } else {
            User::findOrFail(Auth::user()->id)->update([
                'password' => Hash::make($request->password),
            ]);

            return redirect()->back()->with('success', 'Password Updated Successfully');
        }
    }
}
